
CREATE OR REPLACE FUNCTION GET_LENGTH(geom SDO_GEOMETRY)                
RETURN NUMBER DETERMINISTIC IS
srid   number;
min_x  number;                        
max_x  number;                        
min_y  number;                        
max_y  number;                        
BEGIN
  srid := geom.sdo_srid;                
  min_x := geom.sdo_ordinates(1);       
  min_y := geom.sdo_ordinates(2);       
  max_x := geom.sdo_ordinates(4);       
  max_y := geom.sdo_ordinates(5);       
  return (sdo_geom.sdo_distance(
	  sdo_geometry(2001, srid, sdo_point_type(min_x, min_y, null),
		       null, null),
	  sdo_geometry(2001, srid, sdo_point_type(max_x, max_y, null),
		       null, null), 0.5));
END;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION GET_HEIGHT(geom SDO_GEOMETRY)                
RETURN NUMBER DETERMINISTIC IS
BEGIN
  return (geom.sdo_ordinates(9));
END;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION CORNER_and_HEADING(geom SDO_GEOMETRY)                
RETURN SDO_POINT_TYPE DETERMINISTIC IS
                                                                                
t number;                             
i integer;                            
min_x  number;                        
max_x  number;                        
min_y  number;                        
max_y  number;                        
heading number;                       
srid integer;                        
BEGIN                                  
srid := geom.sdo_srid;                
min_x := geom.sdo_ordinates(1);       
min_y := geom.sdo_ordinates(2);       
max_x := geom.sdo_ordinates(4);       
max_y := geom.sdo_ordinates(5);       
sdo_util.bearing_tilt_for_points(     
sdo_geometry(2001, srid,             
sdo_point_type(min_x, min_y,null), null, null),               
sdo_geometry(2001, srid,             
sdo_point_type(max_x, max_y,null), null, null),                
0.05, heading, t);                  
heading := heading * 180/3.14159265358979323846;                                                                     
return (sdo_point_type(min_x, min_y, heading));                                                                      
end;
/
show errors;


-- Create proceudre for writing pictures to files

CREATE OR REPLACE PROCEDURE write_picture(
directory varchar2, bgrp_id number,
bid number, fid number) IS 
picblob BLOB;
bufstart NUMBER := 1;
bytelen NUMBER := 32000;
bloblen NUMBER;
 mybuf RAW(32000);
 file_ptr utl_file.file_type;
 file_name varchar2(32);

BEGIN
 file_name := 'BG' || TO_CHAR(bgrp_id) || '_B' || TO_CHAR(bid) || '_F' || TO_CHAR(fid) ||'.jpg';
file_ptr := utl_file.fopen(directory, file_name,'wb', 32760);

 bufstart := 1;
bytelen := 32000;

select texture into picblob from building_facade_3d
 WHERE building_id = bid and facade_id = fid;

bufstart := 1;
 bloblen := dbms_lob.getlength(picblob);
WHILE bufstart < bloblen
LOOP
bytelen := bloblen-bufstart+1;
IF (bytelen > 32000) THEN
  bytelen := 32000;
END IF;

dbms_lob.read(picblob,bytelen,bufstart,mybuf);

utl_file.put_raw(file_ptr,mybuf);
utl_file.fflush(file_ptr);

 bufstart := bufstart + bytelen;

END LOOP;

utl_file.fclose(file_ptr);
END;
/
show errors;

create or replace function upd_elinfo(el sdo_elem_info_array)
return sdo_elem_info_array as
  new_el sdo_elem_info_array;
begin
  new_el := el;
  IF (new_el.count > 3) THEN
    IF (new_el(2) = 6) THEN 
      new_el(2) := 1006;
    END IF;
  END IF;
  return new_el;
end;
/
show errors;
